using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Resources;

namespace DS7000FormsControlLib
{
    public partial class UsccFormsControl: UserControl
    {
        private AxusccaxLib.AxUsccOcx m_uscc = null;

        public UsccFormsControl()
        {
            InitializeComponent();
            init();
        }

        public void close()
        {
            if (m_uscc != null)
            {
                m_uscc.EnableActiveX(0);
                m_uscc.Dispose();
                m_uscc = null;
            }
        }

        public void init()
        {
            ResourceManager resources = new ResourceManager(typeof(UsccFormsControl));

            m_uscc = new AxusccaxLib.AxUsccOcx();

            ((ISupportInitialize)(m_uscc)).BeginInit();
            SuspendLayout();

            m_uscc.Enabled = true;
            m_uscc.Name = "axCtrl";
            m_uscc.TabIndex = 0;
            m_uscc.Dock = System.Windows.Forms.DockStyle.Fill;

            Controls.Add(m_uscc);
            Name = "AxForm";

            ResumeLayout(false);
            ((ISupportInitialize)(m_uscc)).EndInit();


            OnResize();
            Show();
					  UsccOcxPath = @"D:\Projects\Perforce\DS7000\application_branch\gui\redist\Debug";
            EnableActiveX(1);
					//EnableActiveX(64);
        }

        private void UserControl1_Resize(object sender, EventArgs e)
        {
            OnResize();
        }

        private void OnResize()
        {
            if (m_uscc != null)
            {
                m_uscc.Width = Width;
                m_uscc.Height = Height;
            }
        }

        public void EnableActiveX(int p)
        {
            if (m_uscc != null)
                m_uscc.EnableActiveX(p);
        }

        //  Properties
        public string CtrlName
        {
            get { return m_uscc.applicationScope(); }
            set { m_uscc.setApplicationScope(value); }
        }


        public int ApiVersion
        {
            get { return m_uscc.ApiVersion; }
        }

        public string BuildDate
        {
            get { return m_uscc.BuildDate; }
        }

        public int BuildNumber
        {
            get { return m_uscc.BuildNumber; }
        }

        public string Version
        {
            get { return m_uscc.Version; }
        }

        public string UsccOcxPath
        {
            get { return m_uscc.usccOcxPath();   }
            set { m_uscc.setUsccOcxPath(value);  }
        }

        //  Methods
        public int ShowPage(int page, int securityLevel)
        {
            return m_uscc.ShowPage(page, securityLevel);
        }

        public int SelectLanguage(string locale)
        {
            return m_uscc.SelectLanguage(locale);
        }
    }
}
